/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.base.EvaluatorWrapper;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.definition.rule.Rule;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELExprAnalyzer {
    public MVELAnalysisResult analyzeExpression(PackageBuildContext context, String expr, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes, String contextIndeifier, Class kcontextClass) {
        MVELAnalysisResult result;
        if (expr.trim().length() > 0) {
            boolean typesafe;
            ParserContext parserContext2;
            HashMap<String, Class<?>> variables;
            HashSet<String> requiredInputs;
            Class returnType;
            block25: {
                MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
                MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
                MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
                MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
                MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
                ParserConfiguration conf = data.getParserConfiguration();
                conf.setClassLoader(context.getPackageBuilder().getRootClassLoader());
                ParserContext parserContext1 = new ParserContext(conf);
                if (localTypes != null) {
                    for (Map.Entry<String, Class<?>> entry : localTypes.entrySet()) {
                        parserContext1.addInput(entry.getKey(), entry.getValue());
                    }
                }
                if (availableIdentifiers.getThisClass() != null) {
                    parserContext1.addInput("this", availableIdentifiers.getThisClass());
                }
                parserContext1.setStrictTypeEnforcement(false);
                parserContext1.setStrongTyping(false);
                parserContext1.setInterceptors(dialect.getInterceptors());
                try {
                    returnType = MVEL.analyze(expr, parserContext1);
                }
                catch (Exception e) {
                    BaseDescr base = context instanceof RuleBuildContext ? ((RuleBuildContext)context).getRuleDescr() : context.getParentDescr();
                    DialectUtil.copyErrorLocation(e, context.getParentDescr());
                    context.addError(new DescrBuildError(base, context.getParentDescr(), null, "Unable to Analyse Expression " + expr + ":\n" + e.getMessage()));
                    return null;
                }
                requiredInputs = new HashSet<String>();
                requiredInputs.addAll(parserContext1.getInputs().keySet());
                variables = parserContext1.getVariables();
                if (localTypes != null) {
                    for (String str : localTypes.keySet()) {
                        variables.remove(str);
                    }
                }
                if (availableIdentifiers.getThisClass() != null) {
                    Iterator it = requiredInputs.iterator();
                    while (it.hasNext()) {
                        if (PropertyTools.getFieldOrAccessor(availableIdentifiers.getThisClass(), (String)it.next()) == null) continue;
                        it.remove();
                    }
                }
                parserContext2 = new ParserContext(conf);
                parserContext2.setStrictTypeEnforcement(true);
                parserContext2.setStrongTyping(true);
                parserContext2.setInterceptors(dialect.getInterceptors());
                for (String str : requiredInputs) {
                    Class<Object> cls = availableIdentifiers.getDeclrClasses().get(str);
                    if (cls != null) {
                        parserContext2.addInput(str, cls);
                        continue;
                    }
                    cls = availableIdentifiers.getGlobals().get(str);
                    if (cls != null) {
                        parserContext2.addInput(str, cls);
                        continue;
                    }
                    Class<Object> clazz = cls = availableIdentifiers.getOperators().keySet().contains(str) ? EvaluatorWrapper.class : null;
                    if (cls != null) {
                        parserContext2.addInput(str, cls);
                        continue;
                    }
                    if (str.equals(contextIndeifier)) {
                        parserContext2.addInput(contextIndeifier, kcontextClass);
                    } else if (str.equals("kcontext")) {
                        parserContext2.addInput("kcontext", kcontextClass);
                    }
                    if (str.equals("rule")) {
                        parserContext2.addInput("rule", Rule.class);
                    }
                    if (localTypes == null || (cls = localTypes.get(str)) == null) continue;
                    parserContext2.addInput(str, cls);
                }
                if (availableIdentifiers.getThisClass() != null) {
                    parserContext2.addInput("this", availableIdentifiers.getThisClass());
                }
                typesafe = context.isTypesafe();
                try {
                    returnType = MVEL.analyze(expr, parserContext2);
                    typesafe = true;
                }
                catch (Exception e) {
                    if (!typesafe) break block25;
                    BaseDescr base = context instanceof RuleBuildContext ? ((RuleBuildContext)context).getRuleDescr() : context.getParentDescr();
                    DialectUtil.copyErrorLocation(e, context.getParentDescr());
                    context.addError(new DescrBuildError(base, context.getParentDescr(), null, "Unable to Analyse Expression " + expr + ":\n" + e.getMessage()));
                    return null;
                }
            }
            if (typesafe) {
                requiredInputs = new HashSet();
                requiredInputs.addAll(parserContext2.getInputs().keySet());
                requiredInputs.addAll(variables.keySet());
                variables = parserContext2.getVariables();
                if (localTypes != null) {
                    for (String str : localTypes.keySet()) {
                        variables.remove(str);
                    }
                }
            }
            result = this.analyze(requiredInputs, availableIdentifiers);
            result.setReturnType(returnType);
            result.setMvelVariables(variables);
            result.setTypesafe(typesafe);
        } else {
            result = this.analyze(Collections.EMPTY_SET, availableIdentifiers);
            result.setMvelVariables(new HashMap());
            result.setTypesafe(true);
        }
        return result;
    }

    private MVELAnalysisResult analyze(Set<String> identifiers, BoundIdentifiers availableIdentifiers) {
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(identifiers);
        HashSet<String> notBound = new HashSet<String>(identifiers);
        notBound.remove("this");
        HashMap usedDecls = new HashMap();
        HashMap usedGlobals = new HashMap();
        HashMap<String, EvaluatorWrapper> usedOperators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getDeclrClasses().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedDecls.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getGlobals().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedGlobals.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (Map.Entry<String, Serializable> entry : availableIdentifiers.getOperators().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedOperators.put(entry.getKey(), (EvaluatorWrapper)entry.getValue());
            notBound.remove(entry.getKey());
        }
        result.setBoundIdentifiers(new BoundIdentifiers(usedDecls, usedGlobals, usedOperators, availableIdentifiers.getThisClass()));
        result.setNotBoundedIdentifiers(notBound);
        return result;
    }
}

